#include "LaserRange2DConfigM.h"
#include <stdio.h>
#include <iostream>
#include <assert.h>

namespace DataLog
{
    const char* LaserRange2DConfigM::MSG_NAME="LaserRange2DConfigM";
    Message* LaserRange2DConfigM::readMessage(FILE*r)
    {
        return new LaserRange2DConfigM(r);
    }
    
    LaserRange2DConfigM::LaserRange2DConfigM(FILE* r) : Message(r)
    {
        if (getVersion()==100)
        {
            int sensorTypeLen=0;
            fread(&sensorTypeLen,sizeof(int),1,r);
            sensorType.resize(sensorTypeLen);
            fread(&sensorType[0],sensorTypeLen,1,r);
            
            int sensorNameLen=0;
            fread(&sensorNameLen,sizeof(int),1,r);
            sensorName.resize(sensorNameLen);
            fread(&sensorName[0],sensorNameLen,1,r);
            
            fread(&numberOfBeams,sizeof(unsigned int),1,r);
            fread(&maxRangeMM,sizeof(unsigned int),1,r);
            fread(&fieldOfViewDeg,sizeof(float),1,r);
            fread(orientationQuat,sizeof(float)*4,1,r);
            fread(positionMM,sizeof(float)*3,1,r);
        }
        else
        {
            assert(0 && "Don't know how to read this version");
        }
        
    }
    
    LaserRange2DConfigM::LaserRange2DConfigM(double p_timestamp, std::string p_sensorName, std::string p_sensorType):
    Message(100, p_timestamp), sensorName(p_sensorName), sensorType(p_sensorType)
    {
        numberOfBeams = 0;
        maxRangeMM = 0;
        fieldOfViewDeg = 0.f;
        orientationQuat[0] = 0.f;
        orientationQuat[1] = 0.f;
        orientationQuat[2] = 0.f;
        orientationQuat[3] = 0.f;
        positionMM[0] = 0.f;
        positionMM[1] = 0.f;
        positionMM[2] = 0.f;
    }
    
    
    unsigned int LaserRange2DConfigM::writeMessageData(FILE *file){
        unsigned int bytes = 0;
        int strLength;
        // write sensor type
        strLength = sensorType.size();
        fwrite(&strLength, sizeof(int), 1, file);
        fwrite(&sensorType[0], strLength, 1, file);
        bytes += sizeof(int) + strLength;
        // write sensor length
        strLength = sensorName.size();
        fwrite(&strLength, sizeof(int), 1, file);
        fwrite(&sensorName[0], strLength, 1, file);
        bytes += sizeof(int) + strLength;

        fwrite(&numberOfBeams,sizeof(unsigned int),1,file);
        fwrite(&maxRangeMM,sizeof(unsigned int),1,file);
        fwrite(&fieldOfViewDeg,sizeof(float),1,file);
        fwrite(orientationQuat,sizeof(float)*4,1,file);
        fwrite(positionMM,sizeof(float)*3,1,file);
        bytes += sizeof(unsigned int) + sizeof(unsigned int) + sizeof(float) + sizeof(float)*4 + sizeof(float)*3;
        return bytes;
    }

}
