#include "LaserRange2DDataM.h"
#include <stdio.h>
#include <iostream>
#include <assert.h>

namespace DataLog
{
	const char* LaserRange2DDataM::MSG_NAME="LaserRange2DDataM";
	Message* LaserRange2DDataM::readMessage(FILE*r)
	{
		return new LaserRange2DDataM(r);
	}

	LaserRange2DDataM::LaserRange2DDataM(FILE* r) : Message(r)
	{
		if (getVersion()<=100)
		{
			sensorType="Hokuyo_UTM-30LX";
			sensorName="hok_utm30_1";

			int numRanges=0;
			fread(&numRanges,sizeof(int),1,r);
			rangeData.resize(numRanges);
			fread(&rangeData[0],sizeof(unsigned int),numRanges,r);
		}
                if (getVersion()>=101)
                {
                        int sensorTypeLen=0;
                        fread(&sensorTypeLen,sizeof(int),1,r);
                        sensorType.resize(sensorTypeLen);
                        fread(&sensorType[0],sensorTypeLen,1,r);

                        int sensorNameLen=0;
                        fread(&sensorNameLen,sizeof(int),1,r);
                        sensorName.resize(sensorNameLen);
                        fread(&sensorName[0],sensorNameLen,1,r);

                        int numRanges=0;
                        fread(&numRanges,sizeof(int),1,r);
                        rangeData.resize(numRanges);
                        fread(&rangeData[0],sizeof(unsigned int),numRanges,r);
                }
                if (getVersion()>=102)
                {
                        int numIntensities=0;
                        fread(&numIntensities,sizeof(int),1,r);
                        intensityData.resize(numIntensities);
                        fread(&intensityData[0],sizeof(unsigned int),numIntensities,r);

                        fread(&sensorTimestamp,sizeof(unsigned int),1,r);
                }
                if (getVersion()>=103)
                {
                        assert(0 && "Don't know how to read version 103 or higher");
		}

	}

    LaserRange2DDataM::LaserRange2DDataM(double p_timestamp, std::string p_sensorName, std::string p_sensorType):
    Message(102, p_timestamp), sensorName(p_sensorName), sensorType(p_sensorType)
    {
    }
    

    unsigned int LaserRange2DDataM::writeMessageData(FILE *file){
        unsigned int bytes = 0;
        int strLength;
        // write sensor type
        strLength = sensorType.size();
        fwrite(&strLength, sizeof(int), 1, file);
        fwrite(&sensorType[0], strLength, 1, file);
        bytes += sizeof(int) + strLength;
        // write sensor length
        strLength = sensorName.size();
        fwrite(&strLength, sizeof(int), 1, file);
        fwrite(&sensorName[0], strLength, 1, file);
        bytes += sizeof(int) + strLength;
        // write length
        int numRanges = rangeData.size();
        fwrite(&numRanges, sizeof(int), 1, file);
        bytes += sizeof(int);
        // write data
        fwrite(&rangeData[0], sizeof(unsigned int), numRanges, file);
        bytes += sizeof(unsigned int) * numRanges;
        // write length of intensity data
        int numIntensities = intensityData.size();
        fwrite(&numIntensities, sizeof(int), 1, file);
        bytes += sizeof(int);
        // write intensity data
        fwrite(&intensityData[0], sizeof(unsigned int), numIntensities, file);
        bytes += sizeof(unsigned int) * numIntensities;
        // write sensor timestamp data
        fwrite(&sensorTimestamp, sizeof(unsigned int), 1, file);
        bytes += sizeof(unsigned int);
        // return the number of written bytes
        return bytes;
    }
    
}
