#include "Message.h"
#include <stdio.h>

namespace DataLog
{
	Message::Message(FILE*r)
	{
		fread(&version,sizeof(int),1,r);
		fread(&timestamp,sizeof(double),1,r);
	}

    Message::Message(int p_version, double p_timestamp): version(p_version), timestamp(p_timestamp)
    {
    }

    unsigned int Message::writeMessage(FILE *file){
        // first write the end of file message
        long beginPos = ftell(file);
        const unsigned int END_OF_FILE = 0xFFFFFFFF;
        fwrite(&END_OF_FILE, sizeof(unsigned int), 1, file);
        // write the valid message 1
        const unsigned char VALID_MESSAGE = 0x31;
        fwrite(&VALID_MESSAGE, sizeof(unsigned char), 1, file);
        // write message type
        int type = detail::simpleHash(getMessageName());
        fwrite(&type, sizeof(int), 1, file);
        // write message version
        fwrite(&version, sizeof(int), 1, file);
        // write timestamp
        fwrite(&timestamp, sizeof(double), 1, file);
        // write the actual message
        unsigned int bytes = writeMessageData(file);
        if(bytes == 0xFFFFFFFF){
            // an error occured
            return 0xFFFFFFFF;
        }
        bytes += /*sizeof(unsigned int) +*/ sizeof(unsigned char) + sizeof(int) + sizeof(int) + sizeof(double);
        // write actual message size
        fseek(file, beginPos, SEEK_SET);
        fwrite(&bytes, sizeof(unsigned int), 1, file);
        // go to the end again...
        fseek(file, 0, SEEK_END);
        return bytes;
    }

    namespace detail
    {
        int simpleHash(const char* str)
        {
            int hash=0;
            for ( int i = 0; *str != '\0'; i++ )
            {
                hash += ( *str++ ) * ( i + 119 );
            }
            return hash;
        }
    }
}
