#ifndef MESSAGE_H
#define MESSAGE_H

#include <stdio.h>

namespace DataLog
{
	// Base class for Messages
	// There are a few conventions that need to be obeyed for your own Message types:
	//
	// Messages need to have at least the following methods/variables:
	//
	// MyMessage(FILE* r);
	// static Message* readMessage(FILE* r);
	// static const char* MSG_NAME;
	// const char* getMessageName() const
	// {
	//		return MSG_NAME;
	// }
	//
	// where readMessage and MSG_NAME are defined as follows:
	//
	// const char* MyMessage::MSG_NAME="MyMessage";
	// Message* MyMessage::readMessage(FILE*r)
	// {
	//		return new MyMessage(r);
	// }
	//
	// The constructor MyMessage(FILE* r) has to be defined as
	// MyMessage(FILE* r): Message(r)
	// { .../* your code */ ... }
	// in order to allow the Message Baseclass to read itself from the file first
	// The function body should contain the necessary fread(...) commands to read the content of the message into
	// the message's member variables
	//
	class Message
	{
	public:
		Message(FILE* r);
        Message(int p_version, double p_timestamp);
		virtual ~Message() {}
		virtual const char* getMessageName() const = 0;
        virtual unsigned int writeMessage(FILE *file);

		int getVersion() const { return version; }
		double getTimestamp() const { return timestamp; }
        
    protected:
        virtual unsigned int writeMessageData(FILE *file) = 0;
	private:
		int version;
		double timestamp;
	};
    
    class EndMessage: public Message{
        public:
        EndMessage(): Message(1, 0.){}
        const char* getMessageName() const{ return "END_MESSAGE";}
        protected:
        unsigned int writeMessageData(FILE */*file*/){ return 0xFFFFFFFF; }
    };

    namespace detail
    {
        int simpleHash(const char* str);
    }
    
}

#endif
