#include "RawMessage.h"
#include <stdio.h>

namespace DataLog
{
const unsigned int HEADER_OFFSET =/* sizeof(unsigned int) +*/ sizeof(unsigned char) + sizeof(unsigned int) + sizeof(int) + sizeof(double);

RawMessage::RawMessage(FILE * r, unsigned int p_size, unsigned int p_type): Message(r), size(p_size), type(p_type)
{
    data.resize(size - HEADER_OFFSET);
    fread(&data[0], sizeof(char), size-HEADER_OFFSET, r);
}

unsigned int RawMessage::writeMessage(FILE *file){
    fwrite(&size, sizeof(unsigned int), 1, file);
    // write the valid message 1
    const unsigned char VALID_MESSAGE = 0x31;
    fwrite(&VALID_MESSAGE, sizeof(unsigned char), 1, file);
    // write message type
    fwrite(&type, sizeof(int), 1, file);
    // write message version
    int version = getVersion();
    fwrite(&version, sizeof(int), 1, file);
    // write message timestamp
    double timestamp = getTimestamp();
    fwrite(&timestamp, sizeof(double), 1, file);
    // write message data
    fwrite(&data[0], sizeof(char), size-HEADER_OFFSET, file);
    return size;
}

}
