#include "MessageReader.H"
#include <nrt/Core/Blackboard/Message.H>
#include "../MessageLogging/MessageSaver/MessageSaverModule.H"

MessageReader::MessageReader(std::string const & filename, std::string const & fieldName) :
  itsFile(filename),
  itsAr(itsFile),
  itsFieldName(fieldName)
{
  if(!itsFile.is_open()) throw std::runtime_error("Could not open filename: " + filename);
}

bool MessageReader::next()
{
  while(!itsFile.eof())
  {
    std::shared_ptr<MessageSaverData> data(new MessageSaverData);
    itsAr(*data);

    if(data->key.find(itsFieldName) != std::string::npos)
    {
      std::unique_ptr<nrt::Message<nrt::PointCloud2>> msg(new nrt::Message<nrt::PointCloud2>());
      std::istringstream is(data->sermsg); nrt::iarchive ir(is); ir(*msg);
      itsCloud = msg->value();
      return true;
    }
  }
  return false;
}

nrt::PointCloud2 MessageReader::get()
{
  return itsCloud;
}

