#pragma once

#include <string>
#include <unordered_map>
#include <boost/variant.hpp>
#include <boost/optional.hpp>

namespace config
{
  namespace internal
  {
    using Parameter = boost::variant<bool, double, std::string>;

    std::unordered_map<std::string, Parameter> & getmap();

    config::internal::Parameter lookup(std::string const & name);
  }

  void openconfig(std::string const & filename);

  template<class T>
    T lookup(std::string const & path)
  {
    auto & map = internal::getmap();

    auto element = map.find(path);
    if(element != map.end()) 
      return boost::get<T>(element->second);

    internal::Parameter parameter = internal::lookup(path);
    map[path] = parameter;

    return boost::get<T>(parameter);
  }
}
