#include "ConstraintDisplay.H"
#include <nrt/Graphics/Shapes.H>

// ######################################################################
ConstraintDisplay::ConstraintDisplay(std::string const & instanceName) :
  nrt::Component(instanceName),
  renderer_(addSubComponent<nrt::graphics::ShapeRendererBasic>("Constraints")),
  constraint_(100)
{ }

// ######################################################################
void ConstraintDisplay::run()
{
  Eigen::Affine3f t;
  while(running())
  {
    {
      std::lock_guard<std::mutex> _(mtx_);
      t.setIdentity();
      t.rotate(constraint_.rotation().cast<float>());
      //t.scale(constraint_.radii().cast<float>().cwiseMin(constraint_.getThreshold()) / constraint_.getThreshold());
      t.scale(constraint_.radii().cast<float>() / constraint_.getThreshold());
    }

    nrt::graphics::Sphere sphere(t, nrt::forev(), nrt::PixRGBA<uint8_t>(255,0,0,128));

    nrt::graphics::Circle circlex(Eigen::Affine3f(Eigen::AngleAxisf(M_PI/2.0, Eigen::Vector3f::UnitX())));
    nrt::graphics::Circle circley(Eigen::Affine3f(Eigen::AngleAxisf(M_PI/2.0, Eigen::Vector3f::UnitY())));
    nrt::graphics::Circle circlez(Eigen::Affine3f(Eigen::AngleAxisf(M_PI/2.0, Eigen::Vector3f::UnitZ())));

    nrt::graphics::Axes axes;

    renderer_->initFrame();
    axes.render(*renderer_);
    sphere.render(*renderer_);
    circlex.render(*renderer_);
    circley.render(*renderer_);
    circlez.render(*renderer_);
    renderer_->renderFrame();
    std::this_thread::sleep_for(std::chrono::milliseconds(30));
  }
}

// ######################################################################
void ConstraintDisplay::update(PlaneConstraint const & constraint)
{
  std::lock_guard<std::mutex> _(mtx_);
  constraint_ = constraint;
}
