/*! @file MessageLogging/MessageSaver/MessageSaverModule.H */

#ifndef MESSAGELOGGING_MESSAGESAVER_MESSAGESAVERMODULE_H
#define MESSAGELOGGING_MESSAGESAVER_MESSAGESAVERMODULE_H

#include <nrt/Core/Blackboard/Module.H>
#include <nrt/Core/Design/BoundedBuffer.H>
#include <nrt/Core/Image/GenericImage.H>
#include <nrt/PointCloud2/PointCloud2.H>
#include "../../Messages/GaussianPoseMessage.H"
#include "../../Messages/VelodyneIMUMessage.H"
#include "../../MessageLogging/MessageSaverData.H"

//// namespace for ports and parameters of MessageSaverModule
//namespace messagesavermodule
//{
//  //! Parameter category definition
//  nrt::ParameterCategory const ParamCateg("MessageSaver Parameters");
//
//  //! Parameter definition for file name
//  nrt::ParameterDef<std::string> const
//  ParamDefFilename("filename", "File name to save received messages to", "messages.nrtlog", ParamCateg);
//
//  //! Parameter to start/stop the capture
//  nrt::ParameterDef<bool> const
//  ParamDefCapture("capture", "Start or stop the messages capture", false, ParamCateg);
//
//  //! Subscriber port for point cloud
//  NRT_DECLARE_MESSAGESUBSCRIBER_PORT(InputVelodyne, nrt::Message<nrt::PointCloud2>, void, "Input Velodyne PointCloud");
//
//  //! Subscriber port for point cloud
//  NRT_DECLARE_MESSAGESUBSCRIBER_PORT(InputXtion, nrt::Message<nrt::PointCloud2>, void, "Input Xtion PointCloud");
//
//  //! Subscriber port for xtion rgbd
//  NRT_DECLARE_MESSAGESUBSCRIBER_PORT(InputXtionIm, nrt::Message<nrt::GenericImage>, void, "Input Xtion Image");
//
//  //! Subscriber port for Velodyne IMU raw
//  NRT_DECLARE_MESSAGESUBSCRIBER_PORT(InputVelodyneIMU, VelodyneIMUMessage, void, "Input IMU Data");
//
//  //! Subscriber port for Microstrain IMU
//  NRT_DECLARE_MESSAGESUBSCRIBER_PORT(InputMicrostrainIMU, GaussianPoseMessage, void, "Input Velodyne IMU Data");
//
//  //! Subscriber port for point cloud
//  NRT_DECLARE_MESSAGESUBSCRIBER_PORT(InputBBcloud, nrt::Message<nrt::PointCloud2>, void, "Input Bumblebee PointCloud");
//
//  //! Subscriber port for bumblebee left image
//  NRT_DECLARE_MESSAGESUBSCRIBER_PORT(InputBBleft, nrt::Message<nrt::GenericImage>, void, "Input Bumblebee Left Image");
//
//  //! Subscriber port for bumblebee right image
//  NRT_DECLARE_MESSAGESUBSCRIBER_PORT(InputBBright, nrt::Message<nrt::GenericImage>, void, "Input Bumblebee Right Image");
//
//  //! Subscriber port for bumblebee depth image
//  NRT_DECLARE_MESSAGESUBSCRIBER_PORT(InputBBdepth, nrt::Message<nrt::GenericImage>, void, "Input Bumblebee Depth Image");
//
//  //! Subscriber port for bumblebee disparity image
//  NRT_DECLARE_MESSAGESUBSCRIBER_PORT(InputBBdisparity, nrt::Message<nrt::GenericImage>, void, "Input Bumblebee Disparity Image");
//}
//
////! Simple test message saver
///*! Will be replaced by more core functionality later.
//
//    @author Laurent Itti
//    @keywords Message, log, trace */
//class MessageSaverModule : public nrt::Module,
//                           public nrt::MessageSubscriber<messagesavermodule::InputVelodyne,
//                                                         messagesavermodule::InputXtion,
//                                                         messagesavermodule::InputXtionIm,
//                                                         messagesavermodule::InputMicrostrainIMU,
//                                                         messagesavermodule::InputVelodyneIMU,
//                                                         messagesavermodule::InputBBcloud,
//                                                         messagesavermodule::InputBBleft,
//                                                         messagesavermodule::InputBBright,
//                                                         messagesavermodule::InputBBdepth,
//                                                         messagesavermodule::InputBBdisparity>
//{
//  public:
//    //! Constructor
//    MessageSaverModule(std::string const & instanceName = "");
//
//    //! Virtual destructor for safe inheritance
//    virtual ~MessageSaverModule();
//
//    void onMessage(messagesavermodule::InputVelodyne       msg);
//    void onMessage(messagesavermodule::InputXtion          msg);
//    void onMessage(messagesavermodule::InputXtionIm        msg);
//    void onMessage(messagesavermodule::InputMicrostrainIMU msg);
//    void onMessage(messagesavermodule::InputVelodyneIMU    msg);
//    void onMessage(messagesavermodule::InputBBcloud        msg);
//    void onMessage(messagesavermodule::InputBBleft         msg);
//    void onMessage(messagesavermodule::InputBBright        msg);
//    void onMessage(messagesavermodule::InputBBdepth        msg);
//    void onMessage(messagesavermodule::InputBBdisparity    msg);
//
//  private:
//    template <class Port> friend class MessageSaverSub;
//    void run();
//    nrt::Parameter<std::string> itsFilename;
//    nrt::Parameter<bool> itsCapture;
//    nrt::BoundedBuffer<std::shared_ptr<MessageSaverData> > itsQ;
//};

#endif // MESSAGELOGGING_MESSAGESAVER_MESSAGESAVERMODULE_H
