#ifndef NRTBASE_MESSAGES_DRIVERS_VELODYNEIMUMESSAGE_H
#define NRTBASE_MESSAGES_DRIVERS_VELODYNEIMUMESSAGE_H

#include <nrt/Core/Blackboard/Message.H>
#include <nrt/Core/Typing/IntegerTypes.H>

namespace vimudata
{
  NRT_DECLARE_MESSAGEFIELD(ax, float, "x linear acceleration (g)");
  NRT_DECLARE_MESSAGEFIELD(ay, float, "y linear acceleration (g)");
  NRT_DECLARE_MESSAGEFIELD(az, float, "z linear acceleration (g)");

  NRT_DECLARE_MESSAGEFIELD(rx, float, "rotational velocity about x (radian/s)");
  NRT_DECLARE_MESSAGEFIELD(ry, float, "rotational velocity about y (radian/s)");
  NRT_DECLARE_MESSAGEFIELD(rz, float, "rotational velocity about z (radian/s)");
}

//! Message about just linear acceleration data
class VelodyneLinAccelMessage : public nrt::CompositeMessage<NRT_MESSAGEFIELD(vimudata::ax),
                                                             NRT_MESSAGEFIELD(vimudata::ay),
                                                             NRT_MESSAGEFIELD(vimudata::az)>
{ };

//! Message about just gyro data
class VelodyneRotVelMessage : public nrt::CompositeMessage<NRT_MESSAGEFIELD(vimudata::rx),
                                                           NRT_MESSAGEFIELD(vimudata::ry),
                                                           NRT_MESSAGEFIELD(vimudata::rz)>
{ };

namespace vimudata
{
  NRT_DECLARE_MESSAGEFIELD(accel, VelodyneLinAccelMessage, "Linear accelerations (g)");
  NRT_DECLARE_MESSAGEFIELD(rotvel, VelodyneRotVelMessage, "Rotational velocities (radians/s)");
  NRT_DECLARE_MESSAGEFIELD(timestamp, nrt::uint32, "time stamp since top of the hour (microseconds)");
}

//! Message that combines linear accel, gyro, and timestamp
class VelodyneIMUMessage : public nrt::CompositeMessage<NRT_MESSAGEFIELD(vimudata::accel),
                                                        NRT_MESSAGEFIELD(vimudata::rotvel),
                                                        NRT_MESSAGEFIELD(vimudata::timestamp)>
{ };


#endif // NRTBASE_MESSAGES_DRIVERS_VELODYNEIMUMESSAGE_H

