#include "NormalsComponent.H"

NormalsComponent::NormalsComponent( std::string const & instanceID ) :
  FeatureComponentBase( instanceID ),
  itsSearchParam( features_normals::SearchParam, this ),
  itsSearchMethod( features_normals::SearchMethod, this ),
  itsTwoPass( features_normals::TwoPass, this ),
  itsEpsilon( features_normals::Epsilon, this ),
  itsViewPoint( features_normals::ViewPoint, this )
{ }
    

nrt::PointCloud2 NormalsComponent::computeFeature( nrt::PointCloud2 const input )
{
  return nrt::computePointCloudFeatures( input,
      nrt::Normals( itsSearchMethod.getVal(), itsSearchParam.getVal(), itsTwoPass.getVal(), itsViewPoint.getVal(), itsEpsilon.getVal() ) );
}

nrt::PointCloud2 NormalsComponent::computeFeature( nrt::PointCloud2 const input, nrt::Indices const indices )
{
  return nrt::computePointCloudFeatures( input, indices,
      nrt::Normals( itsSearchMethod.getVal(), itsSearchParam.getVal(), itsTwoPass.getVal(), itsViewPoint.getVal(), itsEpsilon.getVal() ) );
}

// register with the factory
NRTBASE_REGISTER_POINTCLOUDFEATURE( NormalsComponent );
