#pragma once

#include <nrt/Eigen/Eigen.H>
#include <nrt/Core/Design/Optional.H>
#include <Eigen/StdVector>
#include <nrt/PointCloud2/PointCloud2.H>
#include "PlaneDetectionCommon.H"
#include <gtsam/nonlinear/Symbol.h>

class DetectedPlane
{
  public:
  Eigen::Hyperplane<float, 3> plane = {{0,0,0},0};

  Eigen::Matrix4d covariance = Eigen::Matrix4d::Identity();
  Eigen::Matrix4d hessian = Eigen::Matrix4d::Identity();
  Eigen::Matrix3d normalCovariance = Eigen::Matrix3d::Identity();
  double rhoCovariance = 0;
  nrt::Indices indices = {};

  //! The hull (not necessarily convex) around the plane's points
  std::vector<nrt::Point3D<float>> hull;

  //! The area of the hull
  nrt::Optional<float> area = nrt::OptionalEmpty;

  //! The weighted centroid of the points
  nrt::Optional<Eigen::Vector3d> centroid = nrt::OptionalEmpty;

  //! The covariance of the points around the centroid
  /*! This is referred to as Cpp in the paper, and Crr in the code */
  nrt::Optional<Eigen::Matrix3d> pointCovariance = nrt::OptionalEmpty;

  //! The eigenvalues of the points in the plane
  nrt::Optional<Eigen::Vector3d> eigenValues = nrt::OptionalEmpty;

  //! The list of groups that contributed to this plane detection
  std::vector<groupid_t> groups = {};

  //! A unique symbol identifying this plane
  nrt::Optional<gtsam::Symbol> symbol = nrt::OptionalEmpty;

  //! A debugging message
  std::string debugMessage = "";

  struct PastObservation
  {
    PastObservation() = default;
    PastObservation(gtsam::Symbol poseSymbol_, DetectedPlane const & plane_) :
      poseSymbol(poseSymbol_), plane(std::make_shared<DetectedPlane>(plane_))
    { }

    gtsam::Symbol poseSymbol;
    std::shared_ptr<DetectedPlane> plane;
  };
  std::vector<PastObservation> pastObservations = {};
  bool accepted = false;
};
