#pragma once

#include "DetectedPlane.H"
#include <nrt/PointCloud2/Common/Correspondence.H>
#include <Eigen/Geometry>
#include <vector>

//! Find a set of simple, non-unique correspondences between planes
/*! @param maxAngle The minimum angle (in degrees) between two planes
 *  @param maxRhoDifference The maximum offset distance between two planes*/
nrt::Correspondences findSimpleCorrespondences(
    std::vector<DetectedPlane> const & frame1Planes, std::vector<DetectedPlane> const & frame2Planes,
    float const maxAngle=10, float const maxRhoDifference=0.01);

nrt::Correspondences findGoodCorrespondences(std::vector<DetectedPlane> const & frame1Planes, std::vector<DetectedPlane> & frame2Planes);

//! Find the transform from frame2 to frame1 using the MUMC algorithm
/*! As a side effect, the algorithm can also produce the correspondences that it used to compute the transform

  \note If you want to integrate the total transform from the origin you should say:
@code
auto tform = findTransformMUMC(lastPlanes, currentPlanes);
totalTransform = totalTransform * tform.inverse();
@endcode
*/
Eigen::Isometry3d findTransformMUMC (
    std::vector<DetectedPlane> const & frame1Planes, std::vector<DetectedPlane> const & frame2Planes,
    nrt::Optional<nrt::Correspondences&> correspondencesOutput = nrt::OptionalEmpty,
    nrt::Optional<int&> translationRank = nrt::OptionalEmpty,
    nrt::Optional<nrt::Correspondences&> Koutput = nrt::OptionalEmpty
    );

Eigen::Isometry3d findTransformMUMCFast (
    std::vector<DetectedPlane> const & frame1Planes, std::vector<DetectedPlane> const & frame2Planes,
    nrt::Optional<nrt::Correspondences&> correspondencesOutput = nrt::OptionalEmpty,
    nrt::Optional<int&> translationRank = nrt::OptionalEmpty,
    nrt::Optional<Eigen::Matrix3d&> translationCovariance = nrt::OptionalEmpty,
    nrt::Optional<Eigen::Matrix3d&> rotationCovariance = nrt::OptionalEmpty);
