#include "FilterMinLasers.H"
#include "../PlaneDetectionCommon.H"
#include <set>

// ######################################################################
template<size_t numRows>
std::vector<DetectedPlane> filterMinLasers(std::vector<DetectedPlane> const & detectedPlanes,
    size_t const minRows)
{
  std::vector<DetectedPlane> filteredPlanes;
  filteredPlanes.reserve(detectedPlanes.size());

  std::copy_if(detectedPlanes.begin(), detectedPlanes.end(), std::back_inserter(filteredPlanes),
      [minRows](DetectedPlane const & plane)
      {
        std::set<size_t> seenRows;
        for(groupid_t gid : plane.groups)
          seenRows.insert(rowFromGroupId<numRows>(gid));
        return seenRows.size() >= minRows;
      });

  return filteredPlanes;
}

template std::vector<DetectedPlane> filterMinLasers<32>(std::vector<DetectedPlane> const & detectedPlanes, size_t const minRows);

template std::vector<DetectedPlane> filterMinLasers<64>(std::vector<DetectedPlane> const & detectedPlanes, size_t const minRows);
