#include <nrt/PointCloud2/PointCloud2.H>
#include <vector>
#include "../LiDARPlaneDetector.H"

// ######################################################################
/*! Find the groups in a single row
  @param cloud The point cloud.
  @param row The current row in which to find groups.
  @param distanceGaussianSigma The sigma used to smooth the 1D distance signal for the row.
  @param ddThreshold The threshold that the second derivative of the distance signal must cross to consider the point a break.
  @param distanceThreshold The minimum distance between points to consider those points a break.
  @param minGroupPoints The minimum number of points in a group.
  @param mergeDotProductThreshold When merging groups, their dot products must be greater than this threshold.
  @param mergeDistanceThreshold When merging groups, their line segment approximations must be at least this close together
  */
template<size_t numRows>
std::vector<LiDARGroup> findGroupsInRow(nrt::PointCloud2 const & cloud, size_t row,
    float const distanceGaussianSigma    = 2,
    float const ddThreshold              = 0.01,
    float const distanceThreshold        = 1.0,
    size_t const minGroupPoints          = 15,
    float const mergeDotProductThreshold = 0.8,
    float const mergeDistanceThreshold   = 0.03);

// HDL 32E default values
//    float const distanceGaussianSigma    = 2,
//    float const ddThreshold              = 0.01,
//    float const distanceThreshold        = 1.0,
//    size_t const minGroupPoints          = 15,
//    float const mergeDotProductThreshold = 0.8,
//    float const mergeDistanceThreshold   = 0.03);
//
// HDL 64E default values (Karlsruhe)
//    float const distanceGaussianSigma    = 2,
//    float const ddThreshold              = 0.02,
//    float const distanceThreshold        = 2.0,
//    size_t const minGroupPoints          = 6,
//    float const mergeDotProductThreshold = 0.8,
//    float const mergeDistanceThreshold   = 0.5);
