#define EIGEN_NO_DEBUG
#include "Polygonalization.H"
#include "BoostGeometry.H"
#include <nrt/PointCloud2/Common/Transforms.H>
#include <nrt/Core/Geometry/Polygon.H>
#include "Timing.H"

// ######################################################################
std::vector<nrt::Point3D<float>> convexHullPolygonalization(DetectedPlane const & detectedPlane,
    nrt::PointCloud2 const & cloud)
{
  Eigen::Vector3f const normal = -detectedPlane.plane.normal();
  nrt::Indices const & indices = detectedPlane.indices;

  // Get the rotation from the normal of the plane to the Z axis
  Eigen::Quaternionf rotation;
  rotation.setFromTwoVectors(normal, Eigen::Vector3f::UnitZ());

  // Transform the subset of points into 2D by rotating into the plane
  std::vector<nrt::Point2D<float>> points2D(indices.size());
  std::transform(cloud.subset_begin(indices), cloud.subset_end(indices), points2D.begin(), 
      [&rotation](nrt::PointCloud2ConstDataRef<> pointRef)
      {
        Eigen::Vector3f const rotPoint = rotation * pointRef.geometry().getVector3Map();
        return nrt::Point2D<float>(rotPoint.x(), rotPoint.y()); 
      });

  // Get the convex hull around the 2D points
  //std::vector<nrt::Point2D<float>> hull2D;
  //try
  //{
  //  boost::geometry::convex_hull(points2D, hull2D);
  //  boost::geometry::correct(hull2D);
  //}
  //catch(boost::geometry::overlay_invalid_input_exception e)
  //{
  //  std::cerr << "###########################################################" << std::endl;
  //  std::cerr << "###########################################################" << std::endl;
  //  std::cerr << "###########################################################" << std::endl;
  //  std::cerr << "Caught " << e.what() << " in " __FILE__ " on line " << __LINE__ << std::endl;
  //  std::cerr << "###########################################################" << std::endl;
  //  std::cerr << "###########################################################" << std::endl;
  //  std::cerr << "###########################################################" << std::endl;
  //}
  
  nrt::Polygon<float> hull2D = nrt::Polygon<float>::approximateConvexHull(points2D).vertices();

  // Transform the 2D hull back into 3D
  Eigen::Hyperplane<float, 3> const & plane = detectedPlane.plane;
  auto const inverseRotation = rotation.inverse();
  std::vector<nrt::Point3D<float>> hull3D(hull2D.size());
  std::transform(hull2D.begin(), hull2D.end(), hull3D.begin(), 
      [plane, &inverseRotation](nrt::Point2D<float> const & p) 
      { 
        Eigen::Vector3f const p3 = plane.projection(inverseRotation*Eigen::Vector3f(p.x(), p.y(), 0.0f)); 
        return nrt::Point3D<float>(p3.x(), p3.y(), p3.z());
      });

  return hull3D;
}
