#include "ShrinkPlane.H"

DetectedPlane shrinkPlane(DetectedPlane const & plane, nrt::PointCloud2 const & cloud)
{
  DetectedPlane p = plane;

  float const distanceThreshold = 0.05;

  p.indices.clear();
  std::copy_if(plane.indices.begin(), plane.indices.end(), std::back_inserter(p.indices),
      [plane, cloud, distanceThreshold](size_t index) 
      {
        return plane.plane.absDistance(cloud[index].getVector3Map()) < distanceThreshold; 
      });

  return p;
}
