#pragma once

#include "../LiDARPlaneDetector.H"
#include <vector>
#include "../DetectedPlane.H"

//! Merge detected planes that were voted for by the same sets of groups
/*! The steps to the algorithm are as follows:
    1) For each group:

       1a) Find the best plane that the group voted for. This is determined by
           the plane which best fits the points above and below the group.

       1b) Discard any planes whose normal is more than normalModeThresh away
           from the best plane's normal.

    2) Create a graph which has one vertex per plane, and edges between vertices
       exist of a group voted for both planes.

    3) Find connected components in the graph, discarding any component with
       less than two vertices.

    4) For each component, create a new DetectedPlane that is fit to the union
       of all points of the planes in the component.

   @param maxNeighborDist The maximum average distance from a prospective
   best plane (in step 1a) to the above and below point neighbors.

   @param normalModeThreshold The threshold in step 1b to determine whether
   a given plane belongs to the dominant mode for a group.  */
template<size_t numRows>
std::vector<DetectedPlane> smartMerge(std::vector<DetectedPlane> const & detectedPlanes,
    std::array<std::vector<LiDARGroup>, numRows> const & groups, nrt::PointCloud2 const & cloud,
    float normalModeThreshold = 0.2, float const maxNeighborDist = 0.1);
