#pragma once
#include <map>
#include <string> 
#include <chrono>
#include <assert.h>
#include <iostream>
#include <iomanip>
#include <boost/format.hpp>

namespace timing
{
  struct Info
  {
    typedef std::chrono::high_resolution_clock Clock; 
    typedef std::chrono::duration<double, std::milli> Duration;
  
    Info() : maximum(0), mean(0), m2(0), n(0) {}
    
    Clock::time_point start;

    Duration maximum;
    Duration mean;
    Duration m2;
    
    size_t n;
  };

  std::map<std::string, Info> & get_info();

  void start(std::string const & name);
  void stop(std::string const & name);
  Info::Duration mean(std::string const & name);
  Info::Duration maximum(std::string const & name);
  Info::Duration variance(std::string const & name);
  void report(std::string const & name);
  void reset(std::string const & name);
  void reset_all();
  
  template<class Rep, class Ratio>
  inline void report_all(std::chrono::duration<Rep, Ratio> interval, bool reset_ = false)
  {
    static Info::Clock::time_point last_report = Info::Clock::now();
    if(Info::Clock::now() > last_report + interval)
    {
      last_report = Info::Clock::now();
      std::cout << "------------ Timing ------------" << std::endl;
      for(std::pair<std::string, Info> const & entry : get_info())
      {
        report(entry.first);
        if(reset_) reset(entry.first);
      }
      std::cout << "--------------------------------" << std::endl;
    }
  }


}
