#pragma once
#include <array>
#include <cmath>

namespace velodyne32
{
  // ######################################################################
  //! Convert and index into a row
  inline int idx2row(int idx)
  {
    int const seq = idx % 32;
    int const row = (seq % 2) ? 16+seq/2 : seq/2;
    return row;
  }

  // ######################################################################
  //! Convert an index into a column
  inline int idx2col(int idx)
  {
    int const seq = idx % 32;
    return (idx - seq)/32;
  }

  // A helper class to populate a rowtable
  constexpr int rowTable( int i )
  {
    return ( i < 16 ) ? ( i * 2 ) : ( ( i - 16 ) * 2 + 1 );
  }

  //! Convert a row/column into an index
  constexpr int index(int const row, int const col)
  {
    return col*32 + rowTable(row);
  }

  constexpr float col2angle(int const col, int const maxcols=2188)
  {
    return col < maxcols/2 ? 
      -((float(col) / float(maxcols)) * (2.0*M_PI)) : 
      -((float(col) / float(maxcols)) * (2.0*M_PI)) + 2.0*M_PI;
  }

  constexpr float row2angle(int const row)
  {
     return
        row ==  0 ? M_PI/2.0 - (-30.67 * M_PI/180.0) :
        row ==  1 ? M_PI/2.0 - (-29.33 * M_PI/180.0) :
        row ==  2 ? M_PI/2.0 - (   -28 * M_PI/180.0) :
        row ==  3 ? M_PI/2.0 - (-26.66 * M_PI/180.0) :
        row ==  4 ? M_PI/2.0 - (-25.33 * M_PI/180.0) :
        row ==  5 ? M_PI/2.0 - (   -24 * M_PI/180.0) :
        row ==  6 ? M_PI/2.0 - (-22.67 * M_PI/180.0) :
        row ==  7 ? M_PI/2.0 - (-21.33 * M_PI/180.0) :
        row ==  8 ? M_PI/2.0 - (   -20 * M_PI/180.0) :
        row ==  9 ? M_PI/2.0 - (-18.67 * M_PI/180.0) :
        row == 10 ? M_PI/2.0 - (-17.33 * M_PI/180.0) :
        row == 11 ? M_PI/2.0 - (   -16 * M_PI/180.0) :
        row == 12 ? M_PI/2.0 - (-14.67 * M_PI/180.0) :
        row == 13 ? M_PI/2.0 - (-13.33 * M_PI/180.0) :
        row == 14 ? M_PI/2.0 - (   -12 * M_PI/180.0) :
        row == 15 ? M_PI/2.0 - (-10.67 * M_PI/180.0) :
        row == 16 ? M_PI/2.0 - ( -9.33 * M_PI/180.0) :
        row == 17 ? M_PI/2.0 - (    -8 * M_PI/180.0) :
        row == 18 ? M_PI/2.0 - ( -6.66 * M_PI/180.0) :
        row == 19 ? M_PI/2.0 - ( -5.33 * M_PI/180.0) :
        row == 20 ? M_PI/2.0 - (    -4 * M_PI/180.0) :
        row == 21 ? M_PI/2.0 - ( -2.67 * M_PI/180.0) :
        row == 22 ? M_PI/2.0 - ( -1.33 * M_PI/180.0) :
        row == 23 ? M_PI/2.0 - (     0 * M_PI/180.0) :
        row == 24 ? M_PI/2.0 - (  1.33 * M_PI/180.0) :
        row == 25 ? M_PI/2.0 - (  2.67 * M_PI/180.0) :
        row == 26 ? M_PI/2.0 - (     4 * M_PI/180.0) :
        row == 27 ? M_PI/2.0 - (  5.33 * M_PI/180.0) :
        row == 28 ? M_PI/2.0 - (  6.67 * M_PI/180.0) :
        row == 29 ? M_PI/2.0 - (     8 * M_PI/180.0) :
        row == 30 ? M_PI/2.0 - (  9.33 * M_PI/180.0) :
                    M_PI/2.0 - ( 10.67 * M_PI/180.0) ;
  }
}
