#include <nrt/Core/Model/Component.H>
#include <nrt/PointCloud2/PointCloud2.H>

//namespace groundplanedetector
//{
//  nrt::ParameterDef<size_t> ParamDefRANSACIterations("RansacIterations",
//      "The maximum number of iterations that RANSAC can perform", 1000);
//
//  nrt::ParameterDef<float> ParamDefRANSACProbability("RansacProbability",
//      "The probability of choosing one sample free of outliers", 0.99F);
//
//  nrt::ParameterDef<float> ParamDefInlierThreshold("InlierThreshold",
//      "The maximum distance from a point to the plane to consider the point an inlier", 0.1F);
//}
//
//class GroundPlaneDetector : public nrt::Component
//{
//  public:
//    typedef Eigen::Hyperplane<float, 3> Plane;
//    
//    GroundPlaneDetector(std::string const & instanceName);
//    
//    std::tuple<Plane, nrt::Indices> detect(nrt::PointCloud2 const & cloud, nrt::Optional<Plane> guess);
//    
//  private:
//    nrt::Parameter<size_t> itsRANSACIterationsParam;
//    nrt::Parameter<float> itsRANSACProbabilityParam;
//    nrt::Parameter<float> itsInlierThresholdParam;
//};

std::tuple<Eigen::Hyperplane<float, 3>, nrt::Indices> detectGroundPlane(nrt::PointCloud2 const & cloud,
    size_t const RANSACIterations=1000, float const RANSACProbabilityThreshold=0.99, float const inlierThreshold=0.1,
    nrt::Optional<Eigen::Hyperplane<float,3>> guess = nrt::OptionalEmpty);
