#ifndef POINTCLOUD_REGISTRATION_CONVERGENCE_GICPCONVERGENCECRITERIA_H_
#define POINTCLOUD_REGISTRATION_CONVERGENCE_GICPCONVERGENCECRITERIA_H_

#include <cstddef>
#include <nrt/PointCloud2/PointCloud2.H>
#include <nrt/PointCloud2/Common/Correspondence.H>
#include <nrt/PointCloud2/Registration/Convergence/ConvergenceCriteriaBase.H>

class GICPConvergenceCriteria : public nrt::ConvergenceCriteriaBase
{
  public:
    GICPConvergenceCriteria(
        nrt::PointCloud2::AffineTransform const & guess = nrt::PointCloud2::AffineTransform::Identity(),
        size_t maxIterations = 200,
        double rotationEpsilon = 2e-3,
        double transformationEpsilon = 5e-4 );

    //! Check whether we have converged
    /*! @param[in] iteration Current iteration of the optimization
        @param[in] transform Current transform estimated by the optimization
        @param[in] correspondences The current set of correspondences
        @return Whether convergence has been reached */
    bool converged( size_t const iteration,
                    nrt::PointCloud2::AffineTransform const & transform,
                    nrt::Correspondences const correspondences );

    //! Resets any internal state associated with determining convergence
    inline void reset() {}

    //! Gets the maximum number of iterations for convergence
    inline size_t maxIterations() const
    { return itsMaxIterations; }

    inline void setGuess( nrt::PointCloud2::AffineTransform const & transform )
    { itsPrevTransform = transform; }

  private:
    const size_t itsMaxIterations;
    const double itsRotationEpsilon;
    const double itsTransformationEpsilon;
    nrt::PointCloud2::AffineTransform itsPrevTransform;
};

#endif // POINTCLOUD_REGISTRATION_CONVERGENCE_GICPCONVERGENCECRITERIA_H_
