#include "IMUStateM.h"
#include <stdio.h>
#include <iostream>
#include <assert.h>
#include <string.h>


namespace DataLog
{
	const char* IMUStateM::MSG_NAME="IMUStateM";
	Message* IMUStateM::readMessage(FILE*r)
	{
		return new IMUStateM(r);
	}

	IMUStateM::IMUStateM(FILE* r) : Message(r)
	{
		if (getVersion()<=101)
		{
			sensorName="xsens_1";
			sensorType="xsens_MTi-G";
		}
		else if (getVersion()==102)
		{
			int sensorTypeLen=0;
			fread(&sensorTypeLen,sizeof(int),1,r);
			sensorType.resize(sensorTypeLen);
			fread(&sensorType[0],sensorTypeLen,1,r);

			int sensorNameLen=0;
			fread(&sensorNameLen,sizeof(int),1,r);
			sensorName.resize(sensorNameLen);
			fread(&sensorName[0],sensorNameLen,1,r);
		}
		else
		{
			assert(0 && "Don't know how to deserialize this version");
		}

		fread(&quat[0],sizeof(float),4,r);
		fread(&accel[0],sizeof(float),3,r);
	}

    IMUStateM::IMUStateM(double p_timestamp, const float p_quat[4], const float p_accel[3], std::string p_sensorName, std::string p_sensorType):
    Message(102, p_timestamp), sensorName(p_sensorName), sensorType(p_sensorType)
    {
        memcpy(quat, p_quat, sizeof(float) * 4);
        memcpy(accel, p_accel, sizeof(float) * 3);
    }

    unsigned int IMUStateM::writeMessageData(FILE *file){
        unsigned int bytes = 0;
        int strLength;
        // write sensor type
        strLength = sensorType.size();
        fwrite(&strLength, sizeof(int), 1, file);
        fwrite(&sensorType[0], strLength, 1, file);
        bytes += sizeof(int) + strLength;
        // write sensor length
        strLength = sensorName.size();
        fwrite(&strLength, sizeof(int), 1, file);
        fwrite(&sensorName[0], strLength, 1, file);
        bytes += sizeof(int) + strLength;
        // write quat
        fwrite(&quat[0], sizeof(float), 4, file);
        bytes += sizeof(float) * 4;
        // write accel
        fwrite(&accel[0], sizeof(float), 3, file);
        bytes += sizeof(float) * 3;
        return bytes;
    }

}
