#ifndef RENDERWIDGET_H
#define RENDERWIDGET_H

#include <QWidget>
#include <map>

namespace DataLog
{
	class LogFile;
	class LaserRange2DDataM;
    class LaserRange2DConfigM;
};

class MainWin;

class QTimer;
class RenderWidget : public QWidget
{
	Q_OBJECT
	public:
		RenderWidget(MainWin* parent);
		~RenderWidget();
		
	protected:
		void paintEvent(QPaintEvent *event);

		//void mousePressEvent(QMouseEvent* me);
		//void mouseMoveEvent(QMouseEvent* me);
	public slots:
		void timeout();
		void open();
	private:
        DataLog::LogFile* m_log;
		QTimer* m_timer;	

        void convertLaserRangesToPoints(const DataLog::LaserRange2DDataM* msg);
		std::vector<QPoint> m_laserPoints;

        std::map<std::string, DataLog::LaserRange2DConfigM*> m_laserConfigs;
        
		MainWin* m_parent;
};

#endif
