#include <PointCloud/Features/VelodyneNormalsFLAS.H>
#include <PointCloud/Features/VelodynePlanarity.H>
#include <nrt/Core/Model/Manager.H>
#include <nrt/Graphics/ShapeRendererBasic.H>
#include <nrt/Graphics/Shapes.H>
#include <nrt/PointCloud2/Common/Transforms.H>
#include "MessageReader.H"

using namespace nrt;

// ######################################################################
PointCloud2 getCloud(std::string const & filename, int frame)
{
  static MessageReader reader(filename, "InputVelodyne");
  static int lastFrame = 0;

  for(int i=lastFrame; i<frame; ++i)
  {
    if(i % 100 == 0) NRT_INFO("Frame " << i << " / " << frame);
    reader.next();
  }
  PointCloud2 cloud = reader.get();

  Eigen::Affine3f transform(Eigen::AngleAxisf(-6.0f*M_PI/180.0f, Eigen::Vector3f::UnitX()));

  transformPointCloudInPlace(cloud, transform);

  cloud.addField<PixRGB<byte>>();
  for(auto p : cloud.range<PixRGB<byte>, PixGray<byte>>()) p.get<PixRGB<byte>>() = PixRGB<byte>(p.get<PixGray<byte>>());
  cloud.removeField<PixGray<byte>>();

  lastFrame = frame;
  return cloud;
}

NRT_DECLARE_PARAMETER(filename, std::string,  "The data file or image directory", "/home/rand/drc/messagelogs/hedco0.nrtlog");
NRT_DECLARE_PARAMETER(frame,    int,          "The starting frame number", 1);
struct Parameters : public nrt::Component, public nrt::Parameter<filename, frame>
{ using nrt::Component::Component; };

int main( int argc, char const ** argv )
{
  Manager mgr(argc, argv);

  auto renderer = mgr.addComponent<graphics::ShapeRendererBasic>("Renderer");
  auto parameters = mgr.addComponent<Parameters>("Parameters");
  
  mgr.launch();

  PointCloud2 cloud = getCloud( parameters->filename::get(), parameters->frame::get() );

  VelodyneNormalsFLAS normalsEngine(3,1); // theta, phi

  {
  auto start = std::chrono::high_resolution_clock::now();
  normalsEngine.compute( cloud );
  auto end = std::chrono::high_resolution_clock::now();
  std::cout << "Normals took "
    << std::chrono::duration_cast<std::chrono::duration<double, std::milli>>(end - start).count()
    << "ms" << std::endl;
  }


  //{
  //  auto start = std::chrono::high_resolution_clock::now();
  //  computeVelodynePlanarity(cloud, 3, 1);
  //  auto end = std::chrono::high_resolution_clock::now();
  //  std::cout << "Planarity took "
  //    << std::chrono::duration_cast<std::chrono::duration<double, std::milli>>(end - start).count()
  //    << "ms" << std::endl;
  //}

  graphics::PointCloud cloudGraphics(cloud);
  //cloudGraphics.
  graphics::PointCloudNormals normalsGraphics(cloud, false, 0.15);

  while( true )
  {
    renderer->initFrame();

    cloudGraphics.render(*renderer);
    normalsGraphics.render(*renderer);
    renderer->renderFrame();
  }

  return 0;
}

