#include <iostream>
#include "../../PointCloud/Registration/PlaneConstraint.H"

int main()
{
  PlaneConstraint constraint(4);

  std::vector<Eigen::Vector3f> vectors = {
    {1.0, 0.0, 0.0},
    {1.0, 0.0, 0.0},
    {1.0, 0.0, 0.0},

    {0.0, 1.0, 0.0},
    {0.0, 1.0, 0.0},
    {0.0, 1.0, 0.0},

    //{0.0, 0.0, 0.1},
    //{0.0, 0.0, 0.1},
    //{0.0, 0.0, 0.1},
  };

  //std::vector<Eigen::Vector3f> vectors = {
  //  {+1.0,  +1.1, +0.0},
  //  {+1.0,  +1.0, +0.0},
  //  {+1.0,  +0.9, +0.0},
  //  {+1.2,  +1.3, +0.0},

  //  {+0.0,  +1.2,  -0.9},
  //  {+0.0,  +1.1,  -0.95},
  //  {+0.0,  +1.1,  -1.2},
  //  {+0.0,  +1.0,  +1.1},
  //  {+0.0,  +0.9,  +1.1},

  //  {+1.2,  +0.0,  +1.3},
  //  {+1.1,  +0.0,  +0.8},
  //  {+1.0,  +0.0,  +0.9},
  //  {+1.1,  +0.0,  +1.1},
  //  {+0.9,  +0.0,  +1.1},
  //};

  for(auto v : vectors)
    constraint.addConstraint(v, 1.0);



  std::cout << "Radii: " << constraint.radii().cwiseProduct(constraint.radii()).transpose() << std::endl;
  std::cout << "Rotation: " << std::endl << constraint.rotation() << std::endl;

  std::cout << "SCORE: " << constraint.getScore({1, 0 ,0}) << std::endl;

  for(auto v : vectors)
  {
    auto n = v.normalized();
    std::cout << n.transpose() << " -> " << (constraint.rotation().cast<float>() * n).transpose() << std::endl;
  }


  return 0;
}
