#pragma once

#include <nrt/Core/Model/Component.H>
#include <nrt/Graphics/ShapeRendererBasic.H>
#include <PointCloud/Registration/PlaneConstraint.H>

class ConstraintDisplay : public nrt::Component
{
  public:
    ConstraintDisplay(std::string const & instanceName);

    void update(PlaneConstraint const & constraint);

  protected:
    void run();

  private:
    std::shared_ptr<nrt::graphics::ShapeRendererBasic> renderer_;
    std::mutex mtx_;

    PlaneConstraint constraint_;
};
