#ifndef NRTBASE_MESSAGES_ROBOTICS_GAUSSIANPOSEMESSAGE_H
#define NRTBASE_MESSAGES_ROBOTICS_GAUSSIANPOSEMESSAGE_H

#include <nrt/Eigen/Eigen.H>

#include <nrt/Core/Blackboard/Message.H>
#include <nrt/Probabilistic/Types/GaussianPDF.H>
#include <nrt/Probabilistic/Types/StateVector.H>
#include <limits>

////! A Gaussian representation of a 6D pose with linear and angular velocities and accelerations.
///*  Examples:
//
//    GaussianPoseMessage::unique_ptr poseMsg(new GaussianPoseMessage);
//    GaussianPoseMessage::PoseType & pose = poseMsg->pose;
//
//    GAUSSIANPOSEMESSAGE_TYPEDEFS;
//    pose.mean<Velocity::y>()                    = 39.33952; //(m/s)
//    pose.mean<Position>()                       = Eigen::Vector3d(0, 0, 0);
//    pose.covariance<Orientation>()              = Eigen::Matrix3d::Identity() * 0.01;
//    pose.covariance<AngularVel>().setConstant(UNUSED_FIELD);
//    pose.covariance<Position::x, Velocity::z>() = 0.0;
//    pose.covariance<Position::x>()              == pose.covariance<Position::x, Position::x>();
//    pose.covariance<Position, Velocity>()       = Eigen::Matrix3d::Identity() * 0.001;
//*/
//NRT_DECLARE_MESSAGE(GaussianPoseMessage)
//{
//  public:
//
//    //! Constructor, setting all fields to unused
//    GaussianPoseMessage() { pose.mean<>().setConstant(std::numeric_limits<double>::quiet_NaN()); }
//
//    //! The position of the robot in the world-frame (meters)
//    NRT_STATE_FIELD_GROUP(Position,     (x)(y)(z));
//
//    //! The velocity of the robot in the body-frame (meters / second)
//    NRT_STATE_FIELD_GROUP(Velocity,     (x)(y)(z));
//
//    //! The velocity of the robot in the body-frame (in meters / second^2)
//    NRT_STATE_FIELD_GROUP(Acceleration, (x)(y)(z));
//
//    //! The orientation of the robot as an so3 vector in the world-frame (radians)
//    /*! An so3 vector is an Angle/Axis vector scaled by the angle */
//    NRT_STATE_FIELD_GROUP(Orientation,  (x)(y)(z)(w));
//
//    //! The instantaneous angular velocity in body-frame Euler angles (radians / second)
//    NRT_STATE_FIELD_GROUP(AngularVel,   (x)(y)(z));
//
//    //! The instantaneous angular acceleration in body-frame Euler angles (radians / second^2)
//    NRT_STATE_FIELD_GROUP(AngularAcc,   (x)(y)(z));
//
//    //! A typedef defining the pose of the robot
//    typedef nrt::StateDefinition<Position, Velocity, Acceleration, Orientation, AngularVel, AngularAcc> PoseDefinition;
//
//    //! A typedef defining a gaussian distribution over the pose of the robot
//    typedef nrt::GaussianPDF<PoseDefinition> PoseType;
//
//    //! A Gaussian PDF representing the current pose of the robot.
//    PoseType pose;
//
//    //! Differentiate a rotation matrix
//    static Eigen::Vector3d differentiateRotation(Eigen::Matrix3d const & r, double delta_t)
//    {
//      Eigen::AngleAxisd a(r);
//      double angle = a.angle();
//
//      if(angle == 0)
//        return Eigen::Vector3d(0,0,0);
//
//      return a.axis().normalized() * angle / delta_t;
//    }
//
//    //! Integrate a rotation vector
//    static Eigen::AngleAxisd integrateRotation(Eigen::Vector3d const & so3, double delta_t)
//    {
//      double const angle = so3.norm();
//      if(angle == 0)
//        return Eigen::AngleAxisd::Identity();
//      else
//        return Eigen::AngleAxisd(angle*delta_t, so3 / angle);
//    }
//
//    static Eigen::Vector4d rotToQuat(Eigen::Matrix3d const & r)
//    {
//      Eigen::Quaterniond q(r);
//      q.normalize();
//      nrt::StateVector<nrt::StateDefinition<Orientation>> s;
//      s.access<Orientation::x>() = q.x();
//      s.access<Orientation::y>() = q.y();
//      s.access<Orientation::z>() = q.z();
//      s.access<Orientation::w>() = q.w();
//      return s.access<Orientation>();
//    }
//
//    //! Serialization
//    template <class Archive> void serialize(Archive & ar)
//    { ar( pose ); }
//};
//
////! Convenient macro to bring the state field groups out of the GaussianPoseMessage namespace.
//#define GAUSSIANPOSEMESSAGE_TYPEDEFS                                       \
//  typedef typename GaussianPoseMessage::Position             Position;     \
//  typedef typename GaussianPoseMessage::Velocity             Velocity;     \
//  typedef typename GaussianPoseMessage::Acceleration         Acceleration; \
//  typedef typename GaussianPoseMessage::Orientation          Orientation;  \
//  typedef typename GaussianPoseMessage::AngularVel           AngularVel;   \
//  typedef typename GaussianPoseMessage::AngularAcc           AngularAcc;   \
//  static double const UNUSED_FIELD = std::numeric_limits<double>::quiet_NaN();

#endif // NRTBASE_MESSAGES_ROBOTICS_GAUSSIANPOSEMESSAGE_H
