#ifndef ALGORITHMS_POINTCLOUD_FEATURES_COMPONENT_NORMALS_H_
#define ALGORITHMS_POINTCLOUD_FEATURES_COMPONENT_NORMALS_H_

#include <nrt/Core/Model/Parameter.H>
#include "../FeatureComponentBase.H"
#include <nrt/PointCloud2/Features/Normals.H>

namespace features_normals 
{
  static nrt::ParameterCategory Options("Normals estimation related parameters");

  static nrt::ParameterDef<double> SearchParam( "searchparam", 
      "If searchmethod is knn, this is the number of nearest neighbors.\nIf searchmethod is radius, then this is the radius in meters.", 
      3,
      Options );
  
  static nrt::ParameterDef<bool> TwoPass( "twopass", 
      "If true, use more numerically stable two-pass covariance calculation.  If false, use faster one pass version.",
      false,
      Options );
  
  static nrt::ParameterDef<double> Epsilon( "epsilon", 
      "Required accuracy for approximate KNN search", 
      0.0,
      Options );
  
  static nrt::ParameterDef<nrt::PointCloud2::Geometry> ViewPoint( "viewpoint", 
      "Location from which normals should be estimated", 
      nrt::PointCloud2::Geometry(),
      Options );

  static nrt::ParameterDef<nrt::PointCloudSearchMethod> SearchMethod( "searchmethod", 
      "Search method to find neighbors", 
      nrt::PointCloudSearchMethod::knn,
      nrt::PointCloudSearchMethod_Values, Options );
}

//! A component that wraps the normals extraction with parameters
class NormalsComponent : public FeatureComponentBase
{
  public:
    NormalsComponent( std::string const & instanceID = "NormalsComponent" );
    
    virtual nrt::PointCloud2 computeFeature( nrt::PointCloud2 const input );
    
    virtual nrt::PointCloud2 computeFeature( nrt::PointCloud2 const input, nrt::Indices const indices );
    
		static std::string const id() { return "normals"; }

		static std::string const description() { return "Calculates surface normals for a point cloud."; }

  private:
    nrt::Parameter<double> itsSearchParam;
    nrt::Parameter<nrt::PointCloudSearchMethod> itsSearchMethod;
    nrt::Parameter<bool> itsTwoPass;
    nrt::Parameter<double> itsEpsilon;
    nrt::Parameter<nrt::PointCloud2::Geometry> itsViewPoint;
};

#endif // ALGORITHMS_POINTCLOUD_FEATURES_COMPONENT_NORMALS_H_
