#pragma once
#include <vector>
#include <stdlib.h>
#include <nrt/Core/Memory/Allocation.H>

namespace planefiltering
{
  
  typedef std::vector<float, nrt::AlignedAllocator<float, 16>> AlignedVector;

  //! Compute the discrete difference of a 1D signal
  /*! This is computed as just y_{i} = (x_{i} - x_{i-1})*/
  AlignedVector difference(AlignedVector const & v);
  
  void convolveSSE(float const * __restrict__ v, size_t const v_length,
      float const * __restrict__ k, size_t const k_length,
      float * __restrict__ result);
  
  //! Convolve the 1D signal v with the 1D signal k
  AlignedVector convolve(AlignedVector const & v, AlignedVector const & k);
  
  //! Make a 1D Gaussian with sigma standard deviation.
  /*! @returns a 1D Gaussian vector of size half_width*2+1 */
  AlignedVector makeGaussian(size_t half_width, float sigma);
  
  //! Find the first derivative of the given 1D Gaussian
  AlignedVector makeGaussianDifference(size_t half_width, float sigma);
  
  //! Make a 1D difference of Gaussian
  AlignedVector makeDifferenceOfGaussian(size_t half_width, float sigma1, float sigma2_mult);
  
  //! Find the zero crossings of a 1D signal
  std::vector<size_t> zeroCrossings(AlignedVector const & v);
}

