#pragma once

#include "DetectedPlane.H"
#include "AccumulatorBall.H"
#include "PlaneDetectionCommon.H"

namespace planedetect
{
  std::string getEigenVersion();
}

struct alignas(16) LiDARGroup
{
  nrt::Indices indices;
  Eigen::Vector3f centroid, variation, e1, e2, e3;
  std::pair<Eigen::Vector3f, Eigen::Vector3f> endPoints;
  groupid_t id;
  float curvature;
};


template<size_t numRows>
class LiDARPlaneDetector
{
  public:
    LiDARPlaneDetector(int const numTheta, int const numPhi, int const numRho, float const rhoMax,
        float const rhoSigma, bool voteSpread);

    std::vector<DetectedPlane> detect(nrt::PointCloud2 & cloud);

    void setAccumulatorThreshold(float const threshold);

    //! Get the list of groups found in the latest detection (for debugging)
    std::array<std::vector<LiDARGroup>, numRows> const & getGroups();

  private:
    //! The accumulator that holds votes
    AccumulatorBall itsAccumulator;


    std::array<std::vector<LiDARGroup>, numRows> itsGroups;
    bool itsVoteSpread;

    //! A simple range from [0..itsNumRows] useful for functional programming
    std::vector<size_t> itsRowRange;
};
