#pragma once

#include <string> 
#include <chrono>

namespace frame_timing
{
  typedef std::chrono::high_resolution_clock Clock; 
  typedef std::chrono::duration<double, std::milli> Duration;

  void begin_frame();

  void start(std::string const & name);
  void stop(std::string const & name);

  void end_frame();

  void clear();

  std::string frame_json();

  namespace internal { void do_report(); }

  template<class Rep, class Ratio>
  inline void report_all(std::chrono::duration<Rep, Ratio> interval)
  {
    static Clock::time_point last_report = Clock::now();
    if(Clock::now() > last_report + interval)
    {
      last_report = Clock::now();
      internal::do_report();
      clear();
    }
  }

  struct guard
  {
    guard(std::string const & name) : name_(name) { start(name); }
    ~guard() { stop(name_); }

    std::string const name_;
  };
}
