#pragma once

#include "../DetectedPlane.H"
#include "../LiDARPlaneDetector.H"
#include <nrt/PointCloud2/PointCloud2.H>
#include <array>
#include <vector>

template<size_t numRows>
std::vector<DetectedPlane> growRegions(std::vector<DetectedPlane> const & detectedPlanes,
    std::array<std::vector<LiDARGroup>, numRows> const & groups, nrt::PointCloud2 const & cloud,
    float const pointPlaneThreshold = 0.1, size_t const maxIterations = 50);

template<size_t numRows>
std::vector<DetectedPlane> growRegions2(std::vector<DetectedPlane> const & detectedPlanes, nrt::PointCloud2 cloud);
