#include "GICPConvergenceCriteria.H"

GICPConvergenceCriteria::GICPConvergenceCriteria(
        nrt::PointCloud2::AffineTransform const & guess,
        size_t maxIterations,
        double rotationEpsilon,
        double transformationEpsilon ) :
  itsMaxIterations( maxIterations ),
  itsRotationEpsilon( rotationEpsilon ),
  itsTransformationEpsilon( transformationEpsilon ),
  itsPrevTransform( guess )
{ }

bool GICPConvergenceCriteria::converged(
    size_t const iteration,
    nrt::PointCloud2::AffineTransform const & transform,
    nrt::Correspondences const )
{
  double delta = 0.0;

  auto & transformation = transform.matrix();
  auto & previous_transformation = itsPrevTransform.matrix();

  for(int k = 0; k < 4; k++) {
    for(int l = 0; l < 4; l++) {
      double ratio = 1;
      if(k < 3 && l < 3) // rotation part of the transform
        ratio = 1.0 / itsRotationEpsilon;
      else
        ratio = 1.0 / itsTransformationEpsilon;
      double c_delta = ratio*fabs(previous_transformation(k,l) - transformation(k,l));
      if(c_delta > delta)
        delta = c_delta;
    }
  }
  itsPrevTransform = transform;

  if( iteration >= itsMaxIterations || delta < 1 )
  {
    NRT_DEBUG("Converged in " << iteration << " iterations with delta " << delta);
    return true;
  }

  return false;
}
