#include "CorrespondenceRejectionNaN.H"

CorrespondenceRejectionNaN::CorrespondenceRejectionNaN()
{ }

auto CorrespondenceRejectionNaN::reject( nrt::PointCloud2 const source, nrt::PointCloud2 const target,
    nrt::Correspondences const correspondences ) -> nrt::Correspondences
{
  nrt::Correspondences retVal( correspondences.size() );

  size_t numValid = 0;
  for( auto const & i : correspondences )
    if( source[i.sourceIndex].isValid() && target[i.targetIndex].isValid() )
      retVal[numValid++] = i;

  retVal.resize( numValid );

  return retVal;
}
