#pragma once

#include <limits>

#include <nrt/PointCloud2/Registration/Correspondence/Rejection/CorrespondenceRejectionBase.H>

//! Rejects correspondences if either point is nan
class CorrespondenceRejectionNaN : public nrt::CorrespondenceRejectionBase
{
  public:
    CorrespondenceRejectionNaN();

    //! Applies some criterion to an input set of correspondences to prune them
    /*! @param source The pointcloud where source indices came from
        @param target The pointcloud where target indices came from
        @param correspondences The correspondences between source and target
        @return The pruned set of correspondences */
    nrt::Correspondences reject( nrt::PointCloud2 const source,
                                 nrt::PointCloud2 const target,
                                 nrt::Correspondences const correspondences );
};
