#pragma once

#include <nrt/Core/Util/CompilerUtil.H>

NRT_BEGIN_UNCHECKED_INCLUDES;
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#include <Eigen/Geometry>
#pragma GCC diagnostic pop
NRT_END_UNCHECKED_INCLUDES;

#include <nrt/PointCloud2/PointCloud2.H>
#include <nrt/PointCloud2/Common/Correspondence.H>
#include <DetectedPlane.H>


class CeresFunctor
{
  public:
    using Covariance = Eigen::Matrix3d;

    CeresFunctor() {};

    Eigen::Isometry3f operator()(
        std::vector<std::pair<DetectedPlane, DetectedPlane>> sourceTargetPlanes,
        nrt::PointCloud2 const & sourceCloud, nrt::PointCloud2 const & targetCloud,
        nrt::Correspondences const & correspondences,
        std::vector<Covariance> const & mahalanobis,
        Eigen::Isometry3f const & transform,
        Eigen::Isometry3f const & guess);
};
