#ifndef LASERRANGE2DDATAM_H
#define LASERRANGE2DDATAM_H

#include "Message.h"
#include <vector>
#include <string>

namespace DataLog
{
	class LaserRange2DDataM : public Message
	{
	public:
		LaserRange2DDataM(FILE* r);
        LaserRange2DDataM(double p_timestamp, std::string p_sensorName="hok_utm30_1", std::string p_sensorType="Hokuyo_UTM-30LX");
		static Message* readMessage(FILE*r);
		static const char* MSG_NAME;
		const char* getMessageName() const
		{
			return MSG_NAME;
		}

		const std::string& getSensorName() const { return sensorName; }
                const std::string& getSensorType() const { return sensorType; }
                unsigned int getSensorTimestamp() const { return sensorTimestamp; }

                const std::vector<unsigned int>& getRangeData() const { return rangeData; }
                std::vector<unsigned int>& getRangeData(){ return rangeData; }
                const std::vector<unsigned int>& getIntensityData() const { return intensityData; }
                std::vector<unsigned int>& getIntensityData(){ return intensityData; }

    protected:
        virtual unsigned int writeMessageData(FILE *file);

	private:
		std::string sensorName;
                std::string sensorType;
                unsigned int sensorTimestamp;
                std::vector<unsigned int> rangeData;
                std::vector<unsigned int> intensityData;
        };
}

#endif
