#include <nrt/Core/Model/Manager.H>
#include <nrt/Core/Geometry/Polygon.H>
#include <nrt/ImageProc/Drawing/Geometry.H>
#include <nrt/ImageProc/IO/ImageSink/ImageSinks.H>
#include <PointCloud/Features/Planes/details/BoostGeometry.H>
#include <vector>

int main(int argc, char const ** argv)
{
  nrt::Manager mgr(argc, argv);

  auto display = mgr.addComponent<nrt::DisplayImageSink>("MySink");

  mgr.launch();

  srand(time(NULL));

  std::vector<nrt::Point2D<float> > randompoints;
  for (int i = 0; i < 100; ++i)
    randompoints.emplace_back(
        (rand()/float(RAND_MAX)-0.5)*200.0+250,
        (rand()/float(RAND_MAX)-0.5)*200.0+250);

  std::vector<nrt::Point2D<float>> hull;
  boost::geometry::convex_hull(randompoints, hull);

  std::cout << "Area: " << boost::geometry::area(hull) << std::endl;

  std::vector<nrt::Point2D<int32_t>> inthull;
  std::transform(hull.begin(), hull.end(), std::back_inserter(inthull),
      [](nrt::Point2D<float> p) { return nrt::Point2D<int32_t>(p); });

  while(true)
  {
    nrt::Image<nrt::PixRGB<uint8_t>> img(nrt::Dims<int32_t>(500, 500), nrt::ImageInitPolicy::Zeros);

    for(auto p : randompoints)
      nrt::drawCross(img, nrt::Point2D<int32_t>(p), nrt::PixRGB<uint8_t>(255,0,0), 3);

    nrt::drawPolygon(img, nrt::Polygon<int32_t>(inthull), nrt::PixRGBA<uint8_t>(0,0,255,128),2);

    display->out(nrt::GenericImage(img), "image");

  }
}

