#include "Config.H"

#include <libconfig.h++>

namespace
{
  libconfig::Config & getconfig()
  {
    static libconfig::Config config;
    return config;
  }
}

// ######################################################################
std::unordered_map<std::string, config::internal::Parameter> & config::internal::getmap()
{
  static std::unordered_map<std::string, Parameter> map;
  return map;
}

// ######################################################################
void config::openconfig(std::string const & name)
{
  try
  {
    getconfig().readFile(name.c_str());
  }
  catch(libconfig::SettingNotFoundException e)
  {
    throw("Could not open config file: " + std::string(e.getPath()));
  }
}

// ######################################################################
config::internal::Parameter config::internal::lookup(std::string const & name)
{
  libconfig::Config & c = getconfig();

  try
  {
    libconfig::Setting & s = c.lookup(name);

    switch(s.getType())
    {
      case libconfig::Setting::TypeInt: 
        return double(int(s));
      case libconfig::Setting::TypeFloat:
        return double(s);
      case libconfig::Setting::TypeString:
        return std::string(s.c_str());
      case libconfig::Setting::TypeBoolean:
        return bool(s);
      default:
        throw std::runtime_error("Bad type of parameter " + name);
    }
  }
  catch(libconfig::SettingNotFoundException const & e)
  { throw std::runtime_error("Could not find parameter " + std::string(e.getPath())); }
  catch(libconfig::SettingTypeException const & e)
  {
    throw std::runtime_error("Bad setting type " + std::string(e.getPath()));
  }
}
