#include "PlaneSLAM.H"
#include <nrt/Graphics/ShapeRendererBasic.H>
#include <nrt/Graphics/Shapes.H>
#include <LiDARPlaneDetector.H>

nrt::Point3D<float> computeCentroid(std::vector<nrt::Point3D<float>> const & points);

nrt::graphics::Polygon createPlanePolygon(Eigen::Hyperplane<float, 3> const & plane, nrt::PixRGBA<uint8_t> const & color, float size = 2.0,
    Eigen::Affine3f const & frame = Eigen::Affine3f::Identity(),
    nrt::Duration const & duration = nrt::forev());

void createHullPolygon(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes,
    std::vector<nrt::Point3D<float>> const & hull, nrt::PixRGBA<uint8_t> const & color,
    Eigen::Affine3f const & frame, bool drawOutline=true,bool drawFill=false, nrt::Duration const & duration = nrt::forev(),
    float const lineWidth = 1.0);

nrt::PixRGBA<uint8_t> getNormalColor(Eigen::Vector3f const & n, uint8_t alpha=32);

void drawPlanes(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes,
    std::vector<DetectedPlane> const & planes, Eigen::Isometry3d const & tform, uint8_t const opacity=128);

void drawSLAMMap(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes, PlaneSLAM::RenderedMap const & map);

void drawPath(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes, std::vector<Eigen::Isometry3d> const & path);

void drawMenu(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes, std::map<std::string, std::pair<KeySym, bool>> const & drawOptions);

void drawCorrespondences(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes,
    nrt::Correspondences const & correspondences, std::vector<DetectedPlane> const & lastPlanes, std::vector<DetectedPlane> const & planes,
    nrt::PointCloud2 const & lastCloud, nrt::PointCloud2 const & cloud, PlaneSLAM::RenderedMap const & globalMap, Eigen::Isometry3d const & tform, Eigen::Isometry3d const & lastTform);

void drawCurrentCloud(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes, Eigen::Isometry3d const & tform, nrt::PointCloud2 cloud);

void drawPlanarity(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes, Eigen::Isometry3d const & tform, nrt::PointCloud2 cloud);

void drawNormals(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes, Eigen::Isometry3d const & tform, nrt::PointCloud2 cloud,
    bool scaleByCurvature = false);

void drawPICPPoints(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes, Eigen::Isometry3d const & tform, nrt::PointCloud2 cloud, nrt::Indices indices,
    nrt::PixRGB<uint8_t> color = {0, 0, 255});

template <size_t numRows>
void drawBreaksGroups(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes, Eigen::Isometry3d const & tform, nrt::PointCloud2 const cloud,
    std::array<std::vector<LiDARGroup>, numRows> const & groups, bool draw_breaks, bool draw_groups );

void drawIntegratedCloud(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes,
    std::vector<Eigen::Isometry3d> const & transformHistory, std::vector<nrt::PointCloud2> const & cloudHistory);

void drawIntegratedJetCloud(std::vector<std::shared_ptr<nrt::graphics::Shape>> & shapes,
    std::vector<Eigen::Isometry3d> const & transformHistory, std::vector<nrt::PointCloud2> const & cloudHistory, float const minHeight, float const maxHeight);
