#include <vector>
#include <nrt/Core/Geometry/Point.H>
#include <nrt/Eigen/Eigen.H>
#include <nrt/Core/Design/Optional.H>

//! Merge a set of hulls by projecting them all onto the given plane, and then finding the set of unions between them
std::vector<nrt::Point3D<float>> mergeHulls(
    Eigen::Hyperplane<float, 3> const & plane, std::vector<std::vector<nrt::Point3D<float>>> const & hulls);

//! Merge a set of hulls by projecting them all onto the given plane, and then finding the convex hull around them
std::vector<nrt::Point3D<float>> mergeHullsSimple(
    Eigen::Hyperplane<float, 3> const & plane, std::vector<std::vector<nrt::Point3D<float>>> const & hulls);

//! Compute the overlap ratio: (intersection) / (h1 area) 
float overlapRatio(std::vector<nrt::Point3D<float>> const & h1, Eigen::Hyperplane<float, 3> const & p1, 
    std::vector<nrt::Point3D<float>> const & h2, Eigen::Hyperplane<float, 3> const & p2,
    nrt::Optional<float&> h1AreaOutput = nrt::OptionalEmpty, nrt::Optional<float&> h2AreaOutput = nrt::OptionalEmpty);
