#include "Util.H"
#include <iostream>
#include <fstream>

void writePath(std::string const & filename,
    std::vector<Eigen::Isometry3d> const & path, std::vector<std::chrono::microseconds> const & times)
{
  std::cout << "Writing Path! " << filename << std::endl;
  assert(path.size() == times.size());

  std::ofstream logfile(filename);

  for(size_t i=0; i<times.size(); ++i)
  {
    auto const time = times[i].count();
    auto const loc = path[i];

    Eigen::Vector3d pos = loc.translation();
    Eigen::Quaterniond rot(loc.rotation());

    logfile << time << " " << pos.transpose() << " " << rot.coeffs().transpose() << std::endl;
  }

  std::cout << "Finished writing path" << std::endl;
}

std::tuple<Eigen::Vector3d, Eigen::Vector3d> filterCamera(std::vector<Eigen::Isometry3d> const & transformHistory)
{
  if(transformHistory.size() == 0) return std::make_tuple(Eigen::Vector3d(0,0,0), Eigen::Vector3d(0,0,0));

  static bool initialized = false;

  static Eigen::Vector3d filteredPos;
  static Eigen::Quaterniond filteredRot;

  Eigen::Isometry3d pose = transformHistory.back();

  if(!initialized)
  {
    filteredPos = pose.translation();
    filteredRot = pose.rotation();
    initialized = true;
  }

  float const alpha = 0.8;

  filteredPos = (1.0-alpha)*filteredPos + alpha * pose.translation();
  filteredRot = filteredRot.slerp(.1, Eigen::Quaterniond(pose.rotation()));


  Eigen::Vector3d camera = filteredPos + filteredRot * Eigen::Vector3d(0,-40,40);
  Eigen::Vector3d target = filteredPos;

  return std::make_tuple(camera, target);

}
