function [ xyz ] = makeBox( npoints, std, dense )
%makeBox Makes a box in the range [0 1] of points with some noise
% npoints - the number of points along each dimension of the box
% std - the standard deviation of noise to add to the box
% dense - if true, the box is filled with points, if false, just
%         the surface is covered
% returns the points in a 3xN XYZ format

x=linspace(0,1,npoints);
y = x;

if dense
    z = x;
else
    z = [0 1];
end

[X, Y, Z] = ndgrid(x,y,z);
xyz = [X(:),Y(:),Z(:)];
xyz = cat(1,xyz(:,[1 2 3]),xyz(:,[2 3 1]),xyz(:,[3 1 2]));
xyz = unique(xyz,'rows');

% add noise
xyz = xyz + randn(size(xyz))*std;
xyz = xyz';

end