function [ output ] = transformPoints( points, rotation_matrix, translation_vector )
%transformPoints Transforms the input XYZ points with a rotation and
%translation
% points - the Nx3 XYZ points
% rotation_matrix - the 3x3 rotation matrix
% translation_vector - the 3x1 translation vector

output = points;

for i=1:length(points)
    output(:,i) = rotation_matrix * points(:,i) + translation_vector;
end

end

