using Winston

include("geometry.jl")

function transform_plane(T, p)
    n = p[1:3] / norm(p[1:3])
    d = p[4]

    R = T[1:3, 1:3]
    t = T[1:3, 4];

    #return [R*n, d - dot(R*n,t)]
    return [R'*n, d + dot(n,t)]
end

function draw_transformed_plane(p, tform, plane, color="black", length=1)

    plane_t = transform_plane(tform, plane)

    println(plane_t')

    n = plane_t[1:2] / norm(plane_t[1:3])
    d = plane_t[4]

    a = atan2(n[2], n[1]) + pi/2.0

    l2 = length / 2

    offset = [cos(a)*l2; sin(a)*l2]

    c = -n*d

    p0 = c + offset;
    p1 = c - offset;

    # Draw the plane
    add(p, Curve([p0[1] p1[1]], [p0[2] p1[2]], "color", color))

    # Draw the normal
    add(p, Curve([0 c[1]], [0 c[2]], "color", color, "type", "dashed"))

    # Draw the center of the plane
    add(p, Points(c[1], c[2], "color", color))
end

p_0 = [1 1 0 1]

T_i = [Geometry.rotz(pi/4) [1 0 0]';
       [0 0 0]         1]

T_i = inv(T_i)

p = FramedPlot()
setattr(p, "xrange", (-3,3))
setattr(p, "yrange", (-3,3))
setattr(p, "aspect_ratio", 1)

add(p, Points([0], [0], "color", "green", "type", "circle"))

draw_transformed_plane(p, eye(4), p_0)
draw_transformed_plane(p, T_i, p_0, "red")

Winston.display(p)
