

e_index = 3;
w_index = 1;
step = 0.001;

r = [3.13; -1.65; 1.5];
R = expm(skew(r));
t = [3; -8; 9];

n_i = [-1/sqrt(2); -1/sqrt(2); 0];
d_i = 10;

n_0 = n_i;
d_0 = d_i;

differences = [];

err = [n_i - R*n_0; 
       d_i - (d_0 - dot(R*n_0, t))]

H1 = [R * skew(n_0), zeros(3,3);
      -t'*R*skew(n_0), (R*n_0)']

delta = .001;
H1(4,1) = (d_i - (d_0 - dot(R*expm(skew([delta;0;0]))*n_0, t)) - (d_i - (d_0 - dot(R*expm(skew([-delta;0;0]))*n_0, t)))) / (1.0*delta);
H1(4,2) = (d_i - (d_0 - dot(R*expm(skew([0;delta;0]))*n_0, t)) - (d_i - (d_0 - dot(R*expm(skew([0;-delta;0]))*n_0, t)))) / (1.0*delta);
H1(4,3) = (d_i - (d_0 - dot(R*expm(skew([0;0;delta]))*n_0, t)) - (d_i - (d_0 - dot(R*expm(skew([0;0;-delta]))*n_0, t)))) / (1.0*delta);



range = -pi/5:step:pi/5;
for offset = range

  r_delta = r;
  r_delta(w_index) = r_delta(w_index) + offset;
  R_delta = expm(skew(r_delta));

  err_delta = [n_i - R_delta*n_0; 
               d_i - (d_0 - dot(R_delta*n_0, t))];

  expectedError = err(e_index) + H1(e_index, w_index)*offset;

  differences = [differences, err_delta(e_index)-expectedError];

end

plot(range, differences);
