#!/usr/bin/env python

import numpy as np
from scipy import linalg
import matplotlib.pyplot as plt

def uphat(x):
  v1 = x[0]
  v2 = x[1]
  a  = x[2]

  return np.matrix([[0, -a, v1],
                    [a, 0, v2],
                    [0, 0, 0]])

def downhat(X):
  v1 = X[0,2]
  v2 = X[1,2]
  a  = X[1,0]

  return np.matrix([v1, v2, a]).transpose()

def printmat(name, mat): print name, ':\n', mat, '\n-----------'

def expm(X): return np.matrix(linalg.expm(X))

## Code ripped from TooN:::
#def expm(X):
#  mu = downhat(X)
#  theta = mu[2,0]
#  theta_sq = theta * theta
#
#  cross = np.matrix([-theta * mu[1,0], theta * mu[0,0]]).transpose()
#
#  T = np.zeros((3,3))
#
#  T[0:2,0:2] = np.matrix([[np.cos(theta), -np.sin(theta)],
#                          [np.sin(theta), np.cos(theta)]])
#
#  if theta_sq < 1e-8:
#    T[0:2,2] = mu[0:2,0] + 0.5 * cross
#  else:
#    A = None
#    B = None
#    if theta_sq < 1e-6:
#      A = 1.0 - theta_sq * (1.0/6.0) * (1.0 - (1.0/20.0) * theta_sq)
#      B = 0.5 - 0.25 * (1.0/6.0) * theta_sq
#    else:
#      inv_theta = 1.0/theta
#      A = np.sin(theta) * inv_theta
#      B = (1.0 - np.cos(theta)) * (inv_theta * inv_theta)
#
#    T[0:2,2] = (A * mu[0:2,0] + B * cross).transpose()
#
#    printmat('A', A)
#    printmat('mu[0:2,0]', mu[0:2,0])
#    printmat('B', B)
#    printmat('cross', cross)
#    printmat('T[0:2,2]', T[0:2,2])
#
#  return T

def logm(X): return np.real(np.matrix(linalg.logm(X)))

plt.hold(True)
plt.xlim([-5, 5])
plt.ylim([-5, 5])
plt.grid(True)

def draw_axes(p, matrix, color):
  p = np.matrix(p).transpose()
  pt = matrix * p
  px = matrix * expm(uphat([1, 0, 0])) * p
  py = matrix * expm(uphat([0, 1, 0])) * p

  plt.plot(pt[0,0], pt[1,0], 'o', color=color)

  plt.plot([pt[0,0], px[0,0]], [pt[1,0], px[1,0]], 'r')
  plt.plot([pt[0,0], py[0,0]], [pt[1,0], py[1,0]], 'g')

  return pt

def draw_axes_2_tokyo_drift(p, vec, color):
  p = np.matrix(p).transpose()
  vec = np.matrix(vec).transpose()
  xoff = np.matrix([1, 0, 0]).transpose()
  yoff = np.matrix([0, 1, 0]).transpose()

  pt = expm(uphat(vec)) * p
  px = expm(uphat(vec + xoff)) * p
  py = expm(uphat(vec + yoff)) * p

  plt.plot(pt[0,0], pt[1,0], 'o', color=color)

  plt.plot([pt[0,0], px[0,0]], [pt[1,0], px[1,0]], 'r')
  plt.plot([pt[0,0], py[0,0]], [pt[1,0], py[1,0]], 'g')

  return pt


#p = np.matrix([1, 1, 1]).transpose()
#plt.plot(p[0,0], p[1,0], 'go')

#p = draw_axes([1, 1, 1], expm(uphat([0, 0, 0])), color=(0,1,0))
#print p.transpose()
#
#p = draw_axes([1, 1, 1], expm(uphat([2, 0, 0])), color=(0,0,0))
#print p.transpose()
#
#p = draw_axes([1, 1, 1], expm(uphat([0, 0, np.pi/2])), color=(1,0,0))
#print p.transpose()
#
#p = draw_axes([1, 1, 1], expm(uphat([0, 1, np.pi/2])), color=(0,0,1))
#print p.transpose()
#
#p = draw_axes([1, 1, 1], expm(uphat([2, 0, np.pi/2])), color=(1,0,1))
#print p.transpose()

################################################################################

p = draw_axes_2_tokyo_drift([1, 1, 1], [0, 0, 0], color=(0,1,0))
print p.transpose()

p = draw_axes_2_tokyo_drift([1, 1, 1], [2, 0, 0], color=(0,0,0))
print p.transpose()

p = draw_axes_2_tokyo_drift([1, 1, 1], [0, 0, np.pi/2], color=(1,0,0))
print p.transpose()

p = draw_axes_2_tokyo_drift([1, 1, 1], [0, 1, np.pi/2], color=(0,0,1))
print p.transpose()

p = draw_axes_2_tokyo_drift([1, 1, 1], [0, 4, np.pi/4], color=(1,0,1))
print p.transpose()

p = draw_axes_2_tokyo_drift([1, 1, 1], [0, 3, np.pi/4], color=(1,0,1))
print p.transpose()

#p2 = expm(uphat([0, 1, np.pi/1.0])) * p
#plt.plot(p2[0,0], p2[1,0], 'bo')
#print p2.transpose()
#
#p3 = expm(uphat([1, 0, np.pi/1.0])) * p
#plt.plot(p3[0,0], p3[1,0], 'ro')
#print p3.transpose()
#
#p3 = expm(uphat([0, 0, np.pi/1.0])) * p
#plt.plot(p3[0,0], p3[1,0], 'ko')
#print p3.transpose()

plt.ion()
plt.show()

#ntheta = 250
#for i, theta in enumerate(np.linspace(-np.pi*2, np.pi*2, ntheta)):
#  p3 = expm(uphat([0, 1, theta])) * p
#  c = i/float(ntheta)
#  plt.plot(p3[0,0], p3[1,0], '.', color=[c,0,0])
#
#  print 'theta: ', theta * 180/np.pi
#
#  plt.pause(0.0000001)
#
plt.pause(100000)
