/*! @file MessageLogging/MessageSaver/MessageSaverModule.C */

#include "MessageSaverModule.H"
#include <nrt/Core/Blackboard/Exceptions.H>
#include <nrt/External/cereal/types/string.hpp>
#include <nrt/Core/Typing/Demangle.H>
#include <fstream>
#include <sys/statvfs.h>

//// ######################################################################
//MessageSaverModule::MessageSaverModule(std::string const & instanceName) :
//    nrt::Module(instanceName),
//    itsFilename(messagesavermodule::ParamDefFilename, this),
//    itsCapture(messagesavermodule::ParamDefCapture, this),
//    itsQ(10000)
//{ }
//
//// ######################################################################
//MessageSaverModule::~MessageSaverModule()
//{  }
//
//// ######################################################################
//void MessageSaverModule::run()
//{
//
//  // Open output file and archive:
//  NRT_INFO("Saving to file: " << itsFilename.getVal());
//  std::ofstream ostr(itsFilename.getVal());
//  if (ostr.is_open() == false)
//    throw nrt::exception::ModuleException(this, "Failed to open output file", itsFilename.getVal());
//  nrt::oarchive ar(ostr);
//
//  std::ofstream::streampos file_begin = ostr.tellp();
//
//  // Main loop:
//  bool keepgoing = true; size_t siz = 0; size_t count = 0;
//  while (running() || siz)
//  {
//    siz = itsQ.filled_size();
//    if (siz)
//    {
//      std::shared_ptr<MessageSaverData> data = itsQ.pop();
//      if (running() == false && (siz % 10 == 0)) NRT_INFO("Flushing queue, " << siz << " items to go...");
//      ar(*data);
//      ++count;
//      if (count % 100 == 0)
//      {
//        size_t bytes_written = ostr.tellp() - file_begin;
//        float gigabytes_written = bytes_written / std::pow(2.0,30.0);
//
//        // Get some statistics about the filesystem that we're writing to
//        struct statvfs fiData;
//        statvfs(itsFilename.getVal().c_str(), &fiData);
//        size_t const bytes_free = fiData.f_bsize * fiData.f_bfree;
//        float const gigabytes_free = bytes_free / std::pow(2.0, 30.0);
//
//        NRT_INFO(nrt::sformat("Saved %zu messages so far... (%0.2f GB written | %0.2f GB free)", count, gigabytes_written, gigabytes_free));
//      }
//    }
//    else std::this_thread::sleep_for(std::chrono::milliseconds(10));
//  }
//
//  NRT_INFO("Flushing file buffers...");
//}
//
//#define MESSAGE_SAVER_CALLBACK(Port)                                                              \
//void MessageSaverModule::onMessage(Port msg)                                                      \
//{                                                                                                 \
//  if (itsCapture.getVal())                                                                        \
//  {                                                                                               \
//    std::shared_ptr<MessageSaverData> data(new MessageSaverData);                                 \
//    data->key = nrt::demangledName<Port>();                                                       \
//    data->time = nrt::CentralTimer::instance().get().count();                                     \
//    std::ostringstream as; nrt::oarchive archive(as); archive(*msg); data->sermsg = as.str(); \
//    itsQ.push(data);                                                                              \
//  }                                                                                               \
//}
//
//MESSAGE_SAVER_CALLBACK(messagesavermodule::InputVelodyne)
//MESSAGE_SAVER_CALLBACK(messagesavermodule::InputXtion)
//MESSAGE_SAVER_CALLBACK(messagesavermodule::InputXtionIm)
//MESSAGE_SAVER_CALLBACK(messagesavermodule::InputMicrostrainIMU)
//MESSAGE_SAVER_CALLBACK(messagesavermodule::InputVelodyneIMU)
//MESSAGE_SAVER_CALLBACK(messagesavermodule::InputBBcloud)
//MESSAGE_SAVER_CALLBACK(messagesavermodule::InputBBleft)
//MESSAGE_SAVER_CALLBACK(messagesavermodule::InputBBright)
//MESSAGE_SAVER_CALLBACK(messagesavermodule::InputBBdepth)
//MESSAGE_SAVER_CALLBACK(messagesavermodule::InputBBdisparity)
//#undef MESSAGE_SAVER_CALLBACK

// ######################################################################
// Don't forget this to be able to use your module as a runtime-loadable shared object
NRT_REGISTER_MODULE(MessageSaverModule);
