#include "PlaneDetectionCommon.H"

float shortestSquaredDistanceBetweenSegments(Eigen::Vector3f const & s1_begin,
                                             Eigen::Vector3f const & s1_end,
                                             Eigen::Vector3f const & s2_begin,
                                             Eigen::Vector3f const & s2_end)
{
  static float const SMALL_NUM = 0.001f;
  Eigen::Vector3f const u = s1_end - s1_begin;
  Eigen::Vector3f const v = s2_end - s2_begin;
  Eigen::Vector3f const w = s1_begin - s2_begin;
  float const a = u.dot(u);
  float const b = u.dot(v);
  float const c = v.dot(v);
  float const d = u.dot(w);
  float const e = v.dot(w);
  float const D = a*c - b*b;
  float sc, sN, sD = D;
  float tc, tN, tD = D;

  // compute the line parameters of the closest points
  if(D < SMALL_NUM) // lines almost parallel
  {
    sN = 0.0f;
    sD = 1.0f;
    tN = e;
    tD = c;
  }
  else // get the closest points on the infinite lines
  {
    sN = (b*e - c*d);
    tN = (a*e - b*d);
    
    if(sN < 0.0f) // sc < 0 -> the s=0 edge is visible
    {
      sN = 0.0f;
      tN = e;
      tD = c;
    }
    else if(sN > sD) // sc > 1 -> the s=1 edge is visible
    {
      sN = sD;
      tN = e + b;
      tD = c;
    }
  }

  if(tN < 0.0f)
  {
    tN = 0.0f;
    // recompute sc for this edge
    if(-d < 0.0f)
      sN = 0.0f;
    else if(-d > a)
      sN = sD;
    else
    {
      sN = -d;
      sD = a;
    }
  }
  else if(tN > tD)
  {
    tN = tD;
    if((-d + b) < 0.0f)
      sN = 0.0f;
    else if((-d + b) > a)
      sN = sD;
    else
    {
      sN = (-d + b);
      sD = a;
    }
  }

  // finally do the division to get sc and tc
  sc = std::abs(sN) < SMALL_NUM ? 0.0f : sN / sD;
  tc = std::abs(tN) < SMALL_NUM ? 0.0f : tN / tD;

  // Get the difference oef the two closest points
  Eigen::Vector3f const dP = w + (sc * u) - (tc * v);

  return dP.squaredNorm();
}

